<?php
if (!defined('AYENEH_ADMIN')) die('Access Denied');
?>
<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <title><?= isset($pageTitle) ? h($pageTitle) . ' - ' : '' ?>پنل مدیریت آینه</title>
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <!-- Material Icons (از Google Fonts) -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Icons">

    <!-- Fallback: Material Icons از CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/material-design-iconic-font/2.2.0/css/material-design-iconic-font.min.css">

    <!-- Bootstrap Core Css -->
 <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  
    <!-- Waves Effect Css -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/node-waves/0.7.6/waves.min.css" rel="stylesheet" />

    <!-- Animation Css -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css" rel="stylesheet" />

    <!-- Bootstrap Select Css -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.12.4/css/bootstrap-select.min.css" rel="stylesheet" />

    <!-- Custom Css -->
    <link href="css/style.css" rel="stylesheet">
    <link href="css/themes/all-themes.css" rel="stylesheet" />
    <link href="css/material-icons-fix.css" rel="stylesheet">
    
    <?php if (isset($extraCSS)): ?>
        <?= $extraCSS ?>
    <?php endif; ?>
</head>
<body class="theme-red">
    <div class="page-loader-wrapper">
        <div class="loader">
            <div class="preloader">
                <div class="spinner-layer pl-red">
                    <div class="circle-clipper left"><div class="circle"></div></div>
                    <div class="circle-clipper right"><div class="circle"></div></div>
                </div>
            </div>
            <p dir="rtl">لطفا کمی صبر کنید...</p>
        </div>
    </div>
    
    <div class="overlay"></div>

    <!-- Top Bar -->
    <nav class="navbar">
        <div class="container-fluid">
            <div class="navbar-header">
                <a href="javascript:void(0);" class="bars">
                    <i class="material-icons">menu</i>
                </a>
                <a class="navbar-brand" href="index.php">
                    <?= isset($pageTitle) ? h($pageTitle) : 'داشبورد' ?>
                </a>
            </div>
        </div>
    </nav>

    <section>
        <aside id="leftsidebar" class="sidebar">
            <div class="user-info">
                <div class="image"><img src="images/user.png" width="48" height="48" alt="User" /></div>
                <div class="info-container">
                    <div class="name"><?= h($currentAdmin['full_name'] ?? 'ادمین') ?></div>
                    <div class="email-row">
                        <div class="email"><?= h($currentAdmin['email'] ?? '') ?></div>
                        <div class="user-actions">
                            <a href="javascript:void(0);" onclick="openChangePasswordModal()" title="تغییر رمز عبور">
                                <i class="material-icons">vpn_key</i>
                            </a>
                            <a href="logout.php" title="خروج" onclick="return confirm('آیا می‌خواهید از سیستم خارج شوید؟');">
                                <i class="material-icons">exit_to_app</i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="menu">
                <ul class="list">
                    <!-- منوی اصلی -->
                    <li class="header">منوی اصلی</li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : '' ?>">
                        <a href="index.php"><i class="material-icons">dashboard</i><span>داشبورد</span></a>
                    </li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'active' : '' ?>">
                        <a href="reports.php"><i class="material-icons">assessment</i><span>گزارش‌ها</span></a>
                    </li>

                    <!-- منوی کاربران -->
                    <li class="header">مدیریت کاربران</li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : '' ?>">
                        <a href="users.php"><i class="material-icons">people</i><span>لیست کاربران</span></a>
                    </li>
                    <?php if ($auth->hasRole('super_admin')): ?>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'admins.php' ? 'active' : '' ?>">
                        <a href="admins.php"><i class="material-icons">security</i><span>مدیران</span></a>
                    </li>
                    <?php endif; ?>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'notifications.php' ? 'active' : '' ?>">
                        <a href="notifications.php"><i class="material-icons">notifications</i><span>اعلان‌ها</span></a>
                    </li>

                    <!-- سایر منوها -->
                    <li class="header">سایر منوها</li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'packages.php' ? 'active' : '' ?>">
                        <a href="packages.php"><i class="material-icons">card_membership</i><span>پکیج‌ها</span></a>
                    </li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'cycles.php' ? 'active' : '' ?>">
                        <a href="cycles.php"><i class="material-icons">loop</i><span>مدیریت چرخه‌ها</span></a>
                    </li>
                    <li class="<?= (basename($_SERVER['PHP_SELF']) == 'payments.php' || basename($_SERVER['PHP_SELF']) == 'discount_codes.php') ? 'active' : '' ?>">
                        <a href="payments.php"><i class="material-icons">attach_money</i><span>مدیریت پرداخت و تخفیف‌ها</span></a>
                    </li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'feedbacks.php' ? 'active' : '' ?>">
                        <a href="feedbacks.php"><i class="material-icons">feedback</i><span>فیدبک‌ها</span></a>
                    </li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'ai_management.php' ? 'active' : '' ?>">
                        <a href="ai_management.php"><i class="material-icons">psychology</i><span>مدیریت AI</span></a>
                    </li>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'activity_logs.php' ? 'active' : '' ?>">
                        <a href="activity_logs.php"><i class="material-icons">history</i><span>سوابق فعالیت‌ها</span></a>
                    </li>
                    <?php if ($auth->hasRole('super_admin')): ?>
                    <li class="<?= basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : '' ?>">
                        <a href="settings.php"><i class="material-icons">settings</i><span>تنظیمات</span></a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </aside>
    </section>
    
    <section class="content">
        <div class="container-fluid">
            <?php
            // نمایش پیام‌های Flash
            if (function_exists('display_flash_messages')) {
                echo display_flash_messages();
            }
            ?>
