<?php
/**
 * Middleware احراز هویت
 * Authentication Middleware
 */

if (!defined('AYENEH_ADMIN')) {
    die('Access Denied');
}

$auth = Auth::getInstance();

// بررسی ورود
if (!$auth->isLoggedIn()) {
    $session = Session::getInstance();
    $session->setError('لطفاً ابتدا وارد سیستم شوید.');
    redirect('login.php');
    exit;
}

// دریافت اطلاعات ادمین
$currentAdmin = $auth->getAdmin();

/**
 * بررسی دسترسی به نقش خاص
 */
function require_role($role) {
    global $auth, $session;

    if (!$auth->hasRole($role)) {
        $session->setError('شما دسترسی به این بخش را ندارید.');
        redirect('index.php');
        exit;
    }
}

/**
 * بررسی دسترسی به مجوز خاص
 */
function require_permission($permission) {
    global $auth, $session;

    if (!$auth->hasPermission($permission)) {
        $session->setError('شما دسترسی به این عملیات را ندارید.');
        redirect('index.php');
        exit;
    }
}

/**
 * بررسی Super Admin
 */
function require_super_admin() {
    require_role('super_admin');
}

?>