<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت پرداخت و تخفیف‌ها';
$db = Database::getInstance();

// دریافت لیست پرداختی‌ها
$payments = $db->query("
    SELECT
        p.*,
        u.email,
        u.full_name,
        s.plan_type,
        s.current_period_end
    FROM payments p
    LEFT JOIN users u ON p.user_id = u.id
    LEFT JOIN subscriptions s ON p.subscription_id = s.id
    ORDER BY p.created_at DESC
    LIMIT 200
")->fetchAll();

$total = count($payments);

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12">
        <div class="card">
            <div class="header">
                <h2>
                    مدیریت پرداختی‌ها
                    <small><?php echo number_format($total); ?> پرداخت</small>
                </h2>
                <div class="header-dropdown">
                    <a href="discount_codes.php" class="btn btn-primary waves-effect">
                        <i class="material-icons">local_offer</i>
                        مدیریت کدهای تخفیف
                    </a>
                </div>
            </div>

            <div class="body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>کاربر</th>
                                <th>مبلغ</th>
                                <th>درگاه</th>
                                <th>شناسه پرداخت</th>
                                <th>نوع اشتراک</th>
                                <th>تاریخ انقضا</th>
                                <th>وضعیت</th>
                                <th>تاریخ پرداخت</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($payments as $payment): ?>
                            <tr>
                                <td><?php echo $payment['id']; ?></td>
                                <td>
                                    <a href="user_detail.php?id=<?php echo $payment['user_id']; ?>">
                                        <?php echo h($payment['full_name'] ?? $payment['email']); ?>
                                    </a>
                                </td>
                                <td><?php echo number_format($payment['amount'] ?? 0); ?> تومان</td>
                                <td><?php echo h($payment['gateway'] ?? '-'); ?></td>
                                <td><?php echo h($payment['transaction_id'] ?? '-'); ?></td>
                                <td><?php echo $payment['plan_type'] ? getPlanBadge($payment['plan_type']) : '-'; ?></td>
                                <td><?php echo $payment['current_period_end'] ? formatDate($payment['current_period_end']) : '-'; ?></td>
                                <td>
                                    <?php
                                    $status = $payment['status'] ?? 'pending';
                                    $statusColors = [
                                        'completed' => 'bg-green',
                                        'pending' => 'bg-orange',
                                        'failed' => 'bg-red',
                                        'refunded' => 'bg-grey'
                                    ];
                                    $statusLabels = [
                                        'completed' => 'موفق',
                                        'pending' => 'در انتظار',
                                        'failed' => 'ناموفق',
                                        'refunded' => 'بازگشت داده شده'
                                    ];
                                    ?>
                                    <span class="badge <?php echo $statusColors[$status] ?? 'bg-grey'; ?>">
                                        <?php echo $statusLabels[$status] ?? $status; ?>
                                    </span>
                                </td>
                                <td><?php echo formatDate($payment['created_at']); ?></td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($payments)): ?>
                            <tr>
                                <td colspan="9" class="text-center">هیچ پرداختی یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'php/includes/footer.php'; ?>
