<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'مدیریت چرخه‌ها';
$db = Database::getInstance();

// فیلترها
$search = get('search', '');
$feeling = get('feeling', '');
$dateFrom = get('date_from', '');
$dateTo = get('date_to', '');

// ساخت کوئری
$where = [];
$params = [];

if ($search) {
    $where[] = '(u.email LIKE ? OR u.full_name LIKE ? OR c.id = ?)';
    $params[] = "%{$search}%";
    $params[] = "%{$search}%";
    $params[] = $search;
}

if ($feeling) {
    $where[] = 'c.feeling = ?';
    $params[] = $feeling;
}

if ($dateFrom) {
    $where[] = 'DATE(c.created_at) >= ?';
    $params[] = $dateFrom;
}

if ($dateTo) {
    $where[] = 'DATE(c.created_at) <= ?';
    $params[] = $dateTo;
}

$whereClause = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';

$cycles = $db->query("
    SELECT
        c.id,
        c.user_id,
        c.feeling,
        c.q4 as behavior,
        c.q5 as result_outcome,
        c.q3_hawkins as hawkins_level,
        c.q5_level as awareness_level,
        c.created_at,
        u.email,
        u.full_name
    FROM cycles c
    LEFT JOIN users u ON c.user_id = u.id
    {$whereClause}
    ORDER BY c.created_at DESC
    LIMIT 100
", $params)->fetchAll();

$total = count($cycles);

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12">
        <div class="card">
            <div class="header">
                <h2>
                    مدیریت چرخه‌ها
                    <small><?php echo number_format($total); ?> چرخه</small>
                </h2>
            </div>

            <div class="body">
                <!-- فرم جستجو و فیلتر -->
                <form method="GET" action="" class="form-inline m-b-20">
                    <div class="form-group">
                        <input type="text" name="search" class="form-control" placeholder="جستجو (ID، ایمیل، نام)" value="<?php echo h($search); ?>">
                    </div>

                    <div class="form-group">
                        <select name="feeling" class="form-control">
                            <option value="">همه احساسات</option>
                            <option value="reactive" <?php echo $feeling === 'reactive' ? 'selected' : ''; ?>>واکنشی</option>
                            <option value="contracting" <?php echo $feeling === 'contracting' ? 'selected' : ''; ?>>منقبض</option>
                            <option value="growth" <?php echo $feeling === 'growth' ? 'selected' : ''; ?>>رشد</option>
                            <option value="ultimate" <?php echo $feeling === 'ultimate' ? 'selected' : ''; ?>>نهایی</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="date" name="date_from" class="form-control" value="<?php echo h($dateFrom); ?>">
                    </div>

                    <div class="form-group">
                        <input type="date" name="date_to" class="form-control" value="<?php echo h($dateTo); ?>">
                    </div>

                    <button type="submit" class="btn-action waves-effect">
                        <i class="material-icons">search</i>
                        <span>جستجو</span>
                    </button>

                    <a href="cycles.php" class="btn-action waves-effect">
                        <i class="material-icons">refresh</i>
                        <span>بازنشانی</span>
                    </a>
                </form>

                <!-- جدول چرخه‌ها -->
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>کاربر</th>
                                <th>احساس</th>
                                <th>رفتار</th>
                                <th>نتیجه</th>
                                <th>امتیاز هاوکینز</th>
                                <th>سطح آگاهی</th>
                                <th>تاریخ ثبت</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cycles as $cycle): ?>
                            <tr>
                                <td><?php echo $cycle['id']; ?></td>
                                <td>
                                    <a href="user_detail.php?id=<?php echo $cycle['user_id']; ?>">
                                        <?php echo h($cycle['full_name'] ?? $cycle['email']); ?>
                                    </a>
                                </td>
                                <td><?php echo h($cycle['feeling'] ?? '-'); ?></td>
                                <td><?php echo h($cycle['behavior'] ?? '-'); ?></td>
                                <td><?php echo h($cycle['result_outcome'] ?? '-'); ?></td>
                                <td><?php echo number_format($cycle['hawkins_level'] ?? 0); ?></td>
                                <td><?php echo number_format($cycle['awareness_level'] ?? 0, 2); ?>%</td>
                                <td><?php echo formatDate($cycle['created_at']); ?></td>
                                <td class="table-actions">
                                    <a href="cycle_detail.php?id=<?php echo $cycle['id']; ?>" class="btn btn-xs btn-info" title="مشاهده جزئیات">
                                        <i class="material-icons">visibility</i>
                                    </a>
                                    <a href="api/cycle_delete.php?id=<?php echo $cycle['id']; ?>" class="btn btn-xs btn-danger btn-delete" title="حذف">
                                        <i class="material-icons">delete</i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                            <?php if (empty($cycles)): ?>
                            <tr>
                                <td colspan="9" class="text-center">هیچ چرخه‌ای یافت نشد</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$('.btn-delete').on('click', function(e) {
    e.preventDefault();
    if (confirm('آیا از حذف این چرخه اطمینان دارید؟\nاین عمل داده‌ها را از پرامپت‌های AI نیز حذف می‌کند.')) {
        window.location.href = $(this).attr('href');
    }
});
</script>

<?php include 'php/includes/footer.php'; ?>
