<?php
define('AYENEH_ADMIN', true);
require_once '../php/autoload.php';

$auth = Auth::getInstance();
$auth->requireRole(ROLE_ADMIN);

$user_id = (int)get('id');

if (!$user_id) {
    setFlashMessage('error', 'شناسه کاربر نامعتبر است');
    redirect('../users.php');
}

$db = Database::getInstance();

// بررسی وجود کاربر
$user = $db->fetchOne("SELECT * FROM users WHERE id = ?", [$user_id]);

if (!$user) {
    setFlashMessage('error', 'کاربر یافت نشد');
    redirect('../users.php');
}

try {
    // حذف Soft (تغییر وضعیت به deleted)
    $db->update('users', [
        'status' => 'deleted',
        'updated_at' => date('Y-m-d H:i:s')
    ], 'id = ?', [$user_id]);

    // ثبت لاگ
    $adminData = $auth->getAdmin();
    $auth->logActivity($adminData['id'], 'delete_user', 'user', $user_id, [
        'email' => $user['email'],
        'full_name' => $user['full_name']
    ]);

    setFlashMessage('success', 'کاربر با موفقیت حذف شد');
} catch (Exception $e) {
    setFlashMessage('error', 'خطا در حذف کاربر: ' . $e->getMessage());
}

redirect('../users.php');
