<?php
define('AYENEH_ADMIN', true);
require_once '../php/autoload.php';

requireAdmin();

$db = Database::getInstance();
$session = Session::getInstance();

$codeId = (int)get('id', 0);

if (!$codeId) {
    $session->setError('شناسه کد تخفیف نامعتبر است.');
    redirect('../discount_codes.php');
}

try {
    // حذف کد تخفیف
    $deleted = $db->delete('discount_codes', 'id = ?', [$codeId]);

    if ($deleted) {
        $session->setSuccess('کد تخفیف با موفقیت حذف شد.');
    } else {
        $session->setError('کد تخفیف یافت نشد.');
    }
} catch (Exception $e) {
    $session->setError('خطا در حذف کد تخفیف: ' . $e->getMessage());
}

redirect('../discount_codes.php');
