<?php
define('AYENEH_ADMIN', true);
require_once '../php/autoload.php';

$db = Database::getInstance();
$session = Session::getInstance();
$auth = Auth::getInstance();

// بررسی لاگین بودن
if (!$auth->isLoggedIn()) {
    $session->setError('لطفا ابتدا وارد شوید.');
    redirect('../login.php');
}

// فقط Super Admin می‌تواند ادمین حذف کند
if (!$auth->hasRole('super_admin')) {
    $session->setError('شما به این بخش دسترسی ندارید.');
    redirect('../admins.php');
}

$adminId = (int)get('id', 0);

if (!$adminId) {
    $session->setError('شناسه ادمین نامعتبر است.');
    redirect('../admins.php');
}

// بررسی وجود ادمین
$admin = $db->fetchOne("
    SELECT a.*, u.email, u.full_name
    FROM admins a
    INNER JOIN users u ON a.user_id = u.id
    WHERE a.id = ?
", [$adminId]);

if (!$admin) {
    $session->setError('ادمین یافت نشد.');
    redirect('../admins.php');
}

// نمی‌توان خودش را حذف کرد
if ($admin['user_id'] == $auth->getUserId()) {
    $session->setError('شما نمی‌توانید خودتان را از لیست ادمین‌ها حذف کنید.');
    redirect('../admins.php');
}

try {
    // حذف ادمین (فقط از جدول admins، نه از جدول users)
    $deleted = $db->delete('admins', 'id = ?', [$adminId]);

    if ($deleted) {
        // ثبت لاگ
        $currentAdminId = $auth->getAdminId();
        if ($currentAdminId) {
            $db->insert('admin_activity_logs', [
                'admin_id' => $currentAdminId,
                'action' => 'admin_removed',
                'target_type' => 'admin',
                'target_id' => $adminId,
                'description' => 'حذف ادمین: ' . ($admin['full_name'] ?? $admin['email']),
                'ip_address' => $_SERVER['REMOTE_ADDR'] ?? null,
                'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? null,
                'created_at' => date('Y-m-d H:i:s')
            ]);
        }

        $session->setSuccess('ادمین "' . h($admin['full_name'] ?? $admin['email']) . '" با موفقیت از لیست ادمین‌ها حذف شد.');
    } else {
        $session->setError('خطا در حذف ادمین.');
    }

} catch (Exception $e) {
    $session->setError('خطا در حذف ادمین: ' . $e->getMessage());
}

redirect('../admins.php');
