<?php
define('AYENEH_ADMIN', true);
require_once 'php/autoload.php';

$pageTitle = 'سوابق فعالیت‌های ادمین';
$db = Database::getInstance();

// دریافت فیلترها
$filterAction = get('action', '');
$filterAdminId = (int)get('admin_id', 0);
$filterEntityType = get('entity_type', '');

// ساخت کوئری
$where = [];
$params = [];

if ($filterAction) {
    $where[] = "aal.action = ?";
    $params[] = $filterAction;
}

if ($filterAdminId) {
    $where[] = "aal.admin_id = ?";
    $params[] = $filterAdminId;
}

if ($filterEntityType) {
    $where[] = "aal.entity_type = ?";
    $params[] = $filterEntityType;
}

$whereClause = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';

// دریافت لاگ‌ها
$sql = "
    SELECT aal.*,
           u.full_name as admin_name,
           u.email as admin_email,
           a.role as admin_role
    FROM admin_activity_logs aal
    LEFT JOIN admins a ON aal.admin_id = a.id
    LEFT JOIN users u ON a.user_id = u.id
    {$whereClause}
    ORDER BY aal.created_at DESC
    LIMIT 500
";

$logs = $db->query($sql, $params)->fetchAll();

// دریافت لیست ادمین‌ها برای فیلتر
$admins = $db->query("
    SELECT a.id, u.full_name, u.email
    FROM admins a
    LEFT JOIN users u ON a.user_id = u.id
    ORDER BY u.full_name
")->fetchAll();

// لیست اکشن‌ها
$actions = [
    'login' => 'ورود',
    'logout' => 'خروج',
    'create' => 'ایجاد',
    'update' => 'ویرایش',
    'delete' => 'حذف',
    'ban' => 'مسدود کردن',
    'unban' => 'رفع مسدودی',
    'view' => 'مشاهده'
];

// لیست نوع موجودیت‌ها
$entityTypes = [
    'user' => 'کاربر',
    'admin' => 'ادمین',
    'notification' => 'اعلان',
    'package' => 'پکیج',
    'setting' => 'تنظیمات'
];

include 'php/includes/header.php';
?>

<div class="row clearfix">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="header">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <h2>
                        <i class="material-icons" style="vertical-align: middle;">history</i>
                        سوابق فعالیت‌های ادمین
                    </h2>
                    <div>
                        <button type="button" class="btn-action waves-effect" onclick="$('#filterSection').slideToggle();">
                            <i class="material-icons">filter_list</i>
                            <span>فیلتر</span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="body">
                <!-- فیلترها -->
                <div id="filterSection" style="display: none; margin-bottom: 20px;">
                    <form method="GET" action="">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>نوع عملیات</label>
                                    <select name="action" class="form-control">
                                        <option value="">همه</option>
                                        <?php foreach ($actions as $key => $label): ?>
                                            <option value="<?php echo $key; ?>" <?php echo $filterAction === $key ? 'selected' : ''; ?>>
                                                <?php echo $label; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>ادمین</label>
                                    <select name="admin_id" class="form-control">
                                        <option value="">همه</option>
                                        <?php foreach ($admins as $admin): ?>
                                            <option value="<?php echo $admin['id']; ?>" <?php echo $filterAdminId === $admin['id'] ? 'selected' : ''; ?>>
                                                <?php echo h($admin['full_name'] ?? $admin['email']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>نوع موجودیت</label>
                                    <select name="entity_type" class="form-control">
                                        <option value="">همه</option>
                                        <?php foreach ($entityTypes as $key => $label): ?>
                                            <option value="<?php echo $key; ?>" <?php echo $filterEntityType === $key ? 'selected' : ''; ?>>
                                                <?php echo $label; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn-action btn-save waves-effect">
                                    <i class="material-icons">search</i>
                                    <span>جستجو</span>
                                </button>

                                <a href="activity_logs.php" class="btn-action waves-effect">
                                    <i class="material-icons">clear</i>
                                    <span>پاک کردن فیلتر</span>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- جدول لاگ‌ها -->
                <div class="table-responsive">
                    <table id="logsTable" class="table table-bordered table-striped table-hover dataTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>تاریخ و زمان</th>
                                <th>ادمین</th>
                                <th>نقش</th>
                                <th>عملیات</th>
                                <th>موجودیت</th>
                                <th>IP</th>
                                <th>جزئیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($logs)): ?>
                                <?php foreach ($logs as $log): ?>
                                    <tr>
                                        <td><?php echo $log['id']; ?></td>
                                        <td style="direction: ltr; text-align: right;">
                                            <?php echo formatDate($log['created_at'], 'Y/m/d H:i:s'); ?>
                                            <br>
                                            <small class="text-muted"><?php echo timeAgo($log['created_at']); ?></small>
                                        </td>
                                        <td>
                                            <strong><?php echo h($log['admin_name'] ?? 'نامشخص'); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo h($log['admin_email'] ?? '-'); ?></small>
                                        </td>
                                        <td><?php echo get_role_label($log['admin_role'] ?? ''); ?></td>
                                        <td><?php echo getActionBadge($log['action']); ?></td>
                                        <td>
                                            <?php if ($log['entity_type']): ?>
                                                <span class="badge bg-grey"><?php echo h($entityTypes[$log['entity_type']] ?? $log['entity_type']); ?></span>
                                                <?php if ($log['entity_id']): ?>
                                                    <br><small class="text-muted">ID: <?php echo $log['entity_id']; ?></small>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo h($log['ip_address'] ?? '-'); ?>
                                        </td>
                                        <td>
                                            <?php if ($log['details']): ?>
                                                <button type="button" class="btn btn-xs btn-info" onclick="showDetails(<?php echo $log['id']; ?>, '<?php echo h(addslashes($log['details'])); ?>')">
                                                    <i class="material-icons">visibility</i>
                                                </button>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">هیچ لاگی یافت نشد.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php if (count($logs) >= 500): ?>
                    <div class="alert alert-info">
                        <strong>توجه:</strong> فقط 500 رکورد اخیر نمایش داده می‌شود. برای مشاهده سوابق بیشتر از فیلترها استفاده کنید.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal: جزئیات -->
<div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">جزئیات لاگ</h4>
            </div>
            <div class="modal-body">
                <pre id="detailsContent" style="direction: ltr; text-align: left; background: #f5f5f5; padding: 15px; border-radius: 4px; max-height: 400px; overflow-y: auto;"></pre>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">بستن</button>
            </div>
        </div>
    </div>
</div>

<script>
// DataTable برای جستجوی سریع
$(document).ready(function() {
    $('#logsTable').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/fa.json",
            "search": "جستجو:",
            "lengthMenu": "نمایش _MENU_ رکورد",
            "info": "نمایش _START_ تا _END_ از _TOTAL_ رکورد",
            "infoEmpty": "هیچ رکوردی یافت نشد",
            "paginate": {
                "first": "اول",
                "last": "آخر",
                "next": "بعدی",
                "previous": "قبلی"
            }
        },
        "pageLength": 50,
        "order": [[0, "desc"]],
        "columnDefs": [
            { "orderable": false, "targets": [7] }
        ]
    });
});

function showDetails(id, details) {
    try {
        // سعی کن JSON را format کنی
        const parsed = JSON.parse(details);
        $('#detailsContent').text(JSON.stringify(parsed, null, 2));
    } catch (e) {
        // اگر JSON نیست، همان متن را نشان بده
        $('#detailsContent').text(details);
    }
    $('#detailsModal').modal('show');
}
</script>

<?php
// تابع کمکی برای نمایش badge عملیات
function getActionBadge($action) {
    $badges = [
        'login' => '<span class="badge bg-green">ورود</span>',
        'logout' => '<span class="badge bg-grey">خروج</span>',
        'create' => '<span class="badge bg-blue">ایجاد</span>',
        'update' => '<span class="badge bg-orange">ویرایش</span>',
        'delete' => '<span class="badge bg-red">حذف</span>',
        'ban' => '<span class="badge bg-red">مسدود</span>',
        'unban' => '<span class="badge bg-green">رفع مسدودی</span>',
        'view' => '<span class="badge bg-cyan">مشاهده</span>'
    ];
    return $badges[$action] ?? '<span class="badge">' . h($action) . '</span>';
}

include 'php/includes/footer.php';
?>
